﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace OGSNET
{
    /** \brief Win32API 関数 */
    static public class Win32API
    {
        public const int WM_SYSCOMMAND   = unchecked((int)0x00000112);

        public const int MF_BYCOMMAND    = unchecked((int)0x00000000);
        public const int MF_BYPOSITION   = unchecked((int)0x00000400);

        public const int MF_BITMAP       = unchecked((int)0x00000004);
        public const int MF_CHECKED      = unchecked((int)0x00000008);
        public const int MF_DISABLED     = unchecked((int)0x00000002);
        public const int MF_ENABLED      = unchecked((int)0x00000000);
        public const int MF_GRAYED       = unchecked((int)0x00000001);
        public const int MF_MENUBARBREAK = unchecked((int)0x00000020);
        public const int MF_MENUBREAK    = unchecked((int)0x00000040);
        public const int MF_OWNERDRAW    = unchecked((int)0x00000100);
        public const int MF_POPUP        = unchecked((int)0x00000010);
        public const int MF_SEPARATOR    = unchecked((int)0x00000800);
        public const int MF_STRING       = unchecked((int)0x00000000);
        public const int MF_UNCHECKED    = unchecked((int)0x00000000);

        [DllImport("user32.dll")]
        public static extern IntPtr GetSystemMenu(IntPtr hWnd, bool bRevert);

        [DllImport("user32.dll")]
        public static extern int GetMenuItemCount(IntPtr hMenu);
        
        [DllImport("user32.dll")]
        public static extern bool InsertMenu(IntPtr hMenu, int uPosition, int uFlags, int uIDNewItem, string lpNewItem);
    }
}
